/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.render;

import buildcraft.api.transport.pipe.IPipeFlowRenderer;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.pipe.flow.PipeFlowPower;
import java.util.ArrayList;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@SideOnly(value=Side.CLIENT)
public enum PipeFlowRendererPower implements IPipeFlowRenderer<PipeFlowPower>
{
    INSTANCE;


    @Override
    public void render(PipeFlowPower flow, double x, double y, double z, float partialTicks, BufferBuilder bb) {
        double transfer = flow.getMaxTransferForRender(partialTicks);
        if (transfer <= 0.0) {
            return;
        }
        float r = (float)(transfer / (double)4.1f);
        ArrayList<Triple> facesSidesCentersRadiuses = new ArrayList<Triple>();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            facesSidesCentersRadiuses.add(Triple.of((Object)Pair.of((Object)face, null), (Object)new Point3f(0.5f, 0.5f, 0.5f), (Object)new Point3f(r, r, r)));
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (!flow.pipe.isConnected(side)) continue;
                facesSidesCentersRadiuses.add(Triple.of((Object)Pair.of((Object)face, (Object)side), (Object)new Point3f(0.5f + (float)side.func_82601_c() * (0.25f + r / 2.0f), 0.5f + (float)side.func_96559_d() * (0.25f + r / 2.0f), 0.5f + (float)side.func_82599_e() * (0.25f + r / 2.0f)), (Object)new Point3f(side.func_176740_k() == EnumFacing.Axis.X ? 0.25f - r / 2.0f : r, side.func_176740_k() == EnumFacing.Axis.Y ? 0.25f - r / 2.0f : r, side.func_176740_k() == EnumFacing.Axis.Z ? 0.25f - r / 2.0f : r)));
            }
        }
        bb.func_178969_c(x, y, z);
        for (Triple faceSideCenterRadius : facesSidesCentersRadiuses) {
            EnumFacing face = (EnumFacing)((Pair)faceSideCenterRadius.getLeft()).getLeft();
            EnumFacing side = (EnumFacing)((Pair)faceSideCenterRadius.getLeft()).getRight();
            Point3f center = (Point3f)faceSideCenterRadius.getMiddle();
            Point3f radius = (Point3f)faceSideCenterRadius.getRight();
            ModelUtil.UvFaceData uvs = null;
            switch (face.func_176740_k()) {
                case X: {
                    uvs = new ModelUtil.UvFaceData(center.getZ() - radius.getZ(), center.getY() - radius.getY(), center.getZ() + radius.getZ(), center.getY() + radius.getY());
                    break;
                }
                case Y: {
                    uvs = new ModelUtil.UvFaceData(center.getX() - radius.getX(), center.getZ() - radius.getZ(), center.getX() + radius.getX(), center.getZ() + radius.getZ());
                    break;
                }
                case Z: {
                    uvs = new ModelUtil.UvFaceData(center.getX() - radius.getX(), center.getY() - radius.getY(), center.getX() + radius.getX(), center.getY() + radius.getY());
                }
            }
            boolean invert = false;
            if (side != null && face.func_176740_k() == EnumFacing.Axis.X && side.func_176740_k() == EnumFacing.Axis.Y) {
                invert = true;
            }
            if (side != null && face.func_176740_k() == EnumFacing.Axis.Y && side.func_176740_k() == EnumFacing.Axis.Z) {
                invert = true;
            }
            if (side != null && face.func_176740_k() == EnumFacing.Axis.Z && side.func_176740_k() == EnumFacing.Axis.Y) {
                invert = true;
            }
            if (invert) {
                uvs = new ModelUtil.UvFaceData(1.0f - uvs.maxU, 1.0f - uvs.maxV, 1.0f - uvs.minU, 1.0f - uvs.minV);
            }
            uvs = new ModelUtil.UvFaceData(BCTransportSprites.POWER_FLOW.getInterpU(uvs.minU), BCTransportSprites.POWER_FLOW.getInterpV(uvs.minV), BCTransportSprites.POWER_FLOW.getInterpU(uvs.maxU), BCTransportSprites.POWER_FLOW.getInterpV(uvs.maxV));
            ModelUtil.createFace(face, (Tuple3f)center, (Tuple3f)radius, uvs).lighti(15, 15).render(bb);
        }
        bb.func_178969_c(0.0, 0.0, 0.0);
    }
}

