/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.enums.EnumSnapshotType;
import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.api.schematics.ISchematicEntity;
import buildcraft.builders.snapshot.SchematicBlockManager;
import buildcraft.builders.snapshot.SchematicEntityManager;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.lib.misc.NBTUtilBC;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class Blueprint
extends Snapshot {
    public final List<ISchematicBlock> palette = new ArrayList<ISchematicBlock>();
    public int[] data;
    public final List<ISchematicEntity> entities = new ArrayList<ISchematicEntity>();

    @Override
    public Blueprint copy() {
        Blueprint blueprint = new Blueprint();
        blueprint.size = this.size;
        blueprint.facing = this.facing;
        blueprint.offset = this.offset;
        blueprint.palette.addAll(this.palette);
        blueprint.data = (int[])this.data.clone();
        blueprint.entities.addAll(this.entities);
        blueprint.computeKey();
        return blueprint;
    }

    public void replace(ISchematicBlock from, ISchematicBlock to) {
        Collections.replaceAll(this.palette, from, to);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74782_a("palette", (NBTBase)NBTUtilBC.writeCompoundList(this.palette.stream().map(SchematicBlockManager::writeToNBT)));
        NBTTagList list = new NBTTagList();
        for (int z = 0; z < this.size.func_177952_p(); ++z) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int x = 0; x < this.size.func_177958_n(); ++x) {
                    list.func_74742_a((NBTBase)new NBTTagInt(this.data[this.posToIndex(x, y, z)]));
                }
            }
        }
        nbt.func_74782_a("data", (NBTBase)list);
        nbt.func_74782_a("entities", (NBTBase)NBTUtilBC.writeCompoundList(this.entities.stream().map(SchematicEntityManager::writeToNBT)));
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) throws InvalidInputDataException {
        int serializedDataLength;
        int[] serializedDataIntArray;
        super.deserializeNBT(nbt);
        this.palette.clear();
        for (NBTTagCompound schematicBlockTag : NBTUtilBC.readCompoundList(nbt.func_74781_a("palette")).collect(Collectors.toList())) {
            this.palette.add(SchematicBlockManager.readFromNBT(schematicBlockTag));
        }
        this.data = new int[Snapshot.getDataSize(this.size)];
        NBTTagList serializedDataList = nbt.func_150297_b("data", 9) ? nbt.func_150295_c("data", 3) : null;
        int[] nArray = serializedDataIntArray = nbt.func_150297_b("data", 11) ? nbt.func_74759_k("data") : null;
        if (serializedDataIntArray == null && serializedDataList == null) {
            throw new InvalidInputDataException("Can't read a blueprint with no data!");
        }
        int n = serializedDataLength = serializedDataList == null ? serializedDataIntArray.length : serializedDataList.func_74745_c();
        if (serializedDataLength != this.getDataSize()) {
            throw new InvalidInputDataException("Serialized data has length of " + serializedDataLength + ", but we expected " + this.getDataSize() + " (" + this.size.toString() + ")");
        }
        for (int z = 0; z < this.size.func_177952_p(); ++z) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int x = 0; x < this.size.func_177958_n(); ++x) {
                    this.data[this.posToIndex((int)x, (int)y, (int)z)] = serializedDataList == null ? serializedDataIntArray[this.posToIndex(x, y, z)] : serializedDataList.func_186858_c(this.posToIndex(x, y, z));
                }
            }
        }
        for (NBTTagCompound schematicEntityTag : NBTUtilBC.readCompoundList(nbt.func_74781_a("entities")).collect(Collectors.toList())) {
            this.entities.add(SchematicEntityManager.readFromNBT(schematicEntityTag));
        }
    }

    @Override
    public EnumSnapshotType getType() {
        return EnumSnapshotType.BLUEPRINT;
    }

    public class BuildingInfo
    extends Snapshot.BuildingInfo {
        public final List<ItemStack>[] toPlaceRequiredItems;
        public final List<FluidStack>[] toPlaceRequiredFluids;
        public final List<ISchematicBlock> rotatedPalette;
        public final Set<ISchematicEntity> entities;
        public final Map<ISchematicEntity, List<ItemStack>> entitiesRequiredItems;
        public final Map<ISchematicEntity, List<FluidStack>> entitiesRequiredFluids;

        public BuildingInfo(BlockPos basePos, Rotation rotation) {
            super(Blueprint.this, basePos, rotation);
            this.toPlaceRequiredItems = new List[Blueprint.this.getDataSize()];
            this.toPlaceRequiredFluids = new List[Blueprint.this.getDataSize()];
            this.rotatedPalette = ImmutableList.copyOf((Collection)Blueprint.this.palette.stream().map(schematicBlock -> schematicBlock.getRotated(rotation)).collect(Collectors.toList()));
            for (int z = 0; z < this.getSnapshot().size.func_177952_p(); ++z) {
                for (int y = 0; y < this.getSnapshot().size.func_177956_o(); ++y) {
                    for (int x = 0; x < this.getSnapshot().size.func_177958_n(); ++x) {
                        ISchematicBlock schematicBlock2 = this.rotatedPalette.get(Blueprint.this.data[Blueprint.this.posToIndex(x, y, z)]);
                        if (schematicBlock2.isAir()) continue;
                        this.toPlaceRequiredItems[Blueprint.this.posToIndex((int)x, (int)y, (int)z)] = schematicBlock2.computeRequiredItems();
                        this.toPlaceRequiredFluids[Blueprint.this.posToIndex((int)x, (int)y, (int)z)] = schematicBlock2.computeRequiredFluids();
                    }
                }
            }
            ImmutableSet.Builder entitiesBuilder = ImmutableSet.builder();
            ImmutableMap.Builder entitiesRequiredItemsBuilder = ImmutableMap.builder();
            ImmutableMap.Builder entitiesRequiredFluidsBuilder = ImmutableMap.builder();
            for (ISchematicEntity schematicEntity : this.getSnapshot().entities) {
                ISchematicEntity rotatedSchematicEntity = schematicEntity.getRotated(rotation);
                entitiesBuilder.add((Object)rotatedSchematicEntity);
                entitiesRequiredItemsBuilder.put((Object)rotatedSchematicEntity, schematicEntity.computeRequiredItems());
                entitiesRequiredFluidsBuilder.put((Object)rotatedSchematicEntity, schematicEntity.computeRequiredFluids());
            }
            this.entities = entitiesBuilder.build();
            this.entitiesRequiredItems = entitiesRequiredItemsBuilder.build();
            this.entitiesRequiredFluids = entitiesRequiredFluidsBuilder.build();
        }

        @Override
        public Blueprint getSnapshot() {
            return Blueprint.this;
        }
    }
}

