/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.ledger;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.sprite.SpriteNineSliced;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.gui.elem.GuiElementContainerHelp;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.ledger.Ledger_Neptune;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.misc.GuiUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class LedgerHelp
extends Ledger_Neptune {
    private static final SpriteNineSliced[][] SPRITE_HELP_SPLIT = new SpriteNineSliced[2][2];
    private IGuiElement selected = null;
    private boolean foundAny = false;
    private boolean init = false;

    public LedgerHelp(BuildCraftGui gui, boolean expandPositive) {
        super(gui, -3368449, expandPositive);
        this.title = LocaleUtil.localize("gui.ledger.help");
        this.calculateMaxSize();
        ResourceLocation id = new ResourceLocation("buildcraftlib:base");
        this.setOpenProperty(GuiConfigManager.getOrAddBoolean(id, "ledger.help.is_open", false));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.currentWidth == 22.0 && this.currentHeight == 24.0) {
            this.selected = null;
            if (this.openElements.size() == 2) {
                this.openElements.remove(1);
                this.title = LocaleUtil.localize("gui.ledger.help");
                this.calculateMaxSize();
            }
        }
    }

    @Override
    protected void drawIcon(double x, double y) {
        if (!this.init) {
            this.init = true;
            ArrayList<ElementHelpInfo.HelpPosition> elements = new ArrayList<ElementHelpInfo.HelpPosition>();
            for (IGuiElement element : this.gui.shownElements) {
                element.addHelpElements(elements);
            }
            this.foundAny = elements.size() > 0;
        }
        ISprite sprite = this.foundAny ? BCLibSprites.HELP : BCLibSprites.WARNING_MINOR;
        GuiIcon.draw(sprite, x, y, x + 16.0, y + 16.0);
    }

    @Override
    public void drawForeground(float partialTicks) {
        super.drawForeground(partialTicks);
        if (!this.shouldDrawOpen()) {
            return;
        }
        boolean set = false;
        ArrayList<ElementHelpInfo.HelpPosition> elements = new ArrayList<ElementHelpInfo.HelpPosition>();
        for (IGuiElement element : this.gui.shownElements) {
            element.addHelpElements(elements);
            this.foundAny |= elements.size() > 0;
            for (ElementHelpInfo.HelpPosition info : elements) {
                IGuiArea rect = info.target;
                boolean isHovered = rect.contains(this.gui.mouse);
                if (isHovered && this.selected != element && !set) {
                    this.selected = element;
                    GuiElementContainerHelp container = new GuiElementContainerHelp(this.gui, this.positionLedgerInnerStart);
                    info.info.addGuiElements(container);
                    if (this.openElements.size() == 2) {
                        this.openElements.remove(1);
                    }
                    this.openElements.add(container);
                    this.title = LocaleUtil.localize("gui.ledger.help") + ": " + LocaleUtil.localize(info.info.title);
                    this.calculateMaxSize();
                    set = true;
                }
                boolean isSelected = this.selected == element;
                SpriteNineSliced split = SPRITE_HELP_SPLIT[isHovered ? 1 : 0][isSelected ? 1 : 0];
                RenderUtil.setGLColorFromInt(info.info.colour);
                split.draw(rect);
            }
            elements.clear();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        LedgerHelp.SPRITE_HELP_SPLIT[0][0] = GuiUtil.slice(GuiUtil.subRelative(BCLibSprites.HELP_SPLIT, 0.0, 0.0, 8.0, 8.0, 16.0), 2, 2, 6, 6, 8);
        LedgerHelp.SPRITE_HELP_SPLIT[0][1] = GuiUtil.slice(GuiUtil.subRelative(BCLibSprites.HELP_SPLIT, 0.0, 8.0, 8.0, 8.0, 16.0), 2, 2, 6, 6, 8);
        LedgerHelp.SPRITE_HELP_SPLIT[1][0] = GuiUtil.slice(GuiUtil.subRelative(BCLibSprites.HELP_SPLIT, 8.0, 0.0, 8.0, 8.0, 16.0), 2, 2, 6, 6, 8);
        LedgerHelp.SPRITE_HELP_SPLIT[1][1] = GuiUtil.slice(GuiUtil.subRelative(BCLibSprites.HELP_SPLIT, 8.0, 8.0, 8.0, 8.0, 16.0), 2, 2, 6, 6, 8);
    }
}

