/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.IngredientNBTBC;
import gnu.trove.map.hash.TCharObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeBuilderShaped {
    @Nonnull
    private ItemStack result = StackUtil.EMPTY;
    private final List<String> shape = new ArrayList<String>();
    private final TCharObjectHashMap<Object> objects = new TCharObjectHashMap();

    public void clear() {
        this.result = StackUtil.EMPTY;
        this.shape.clear();
        this.objects.clear();
    }

    public RecipeBuilderShaped add(String row) {
        if (this.shape.size() > 0 && this.shape.get(0).length() != row.length()) {
            throw new IllegalArgumentException("Badly sized row! (Other rows = " + this.shape.get(0).length() + ", given row = " + row.length() + ")");
        }
        this.shape.add(row);
        return this;
    }

    public RecipeBuilderShaped map(char c, Object ... values) {
        boolean put = false;
        for (Object v : values) {
            if (v == null || v == StackUtil.EMPTY) continue;
            if (v instanceof Item || v instanceof Block || v instanceof ItemStack || v instanceof String) {
                if (put) continue;
                this.objects.put(c, v);
                put = true;
                continue;
            }
            throw new IllegalArgumentException("Invalid " + v.getClass());
        }
        if (!put) {
            throw new IllegalArgumentException("Didn't find a non-null value!");
        }
        return this;
    }

    public RecipeBuilderShaped setResult(@Nonnull ItemStack result) {
        this.result = result;
        return this;
    }

    public Object[] createRecipeObjectArray() {
        Object[] objs = new Object[this.shape.size() + this.objects.size() * 2];
        int offset = 0;
        for (String s : this.shape) {
            objs[offset++] = s;
        }
        for (Object c : (Object)this.objects.keys()) {
            objs[offset++] = Character.valueOf((char)c);
            objs[offset++] = this.objects.get((char)c);
        }
        return objs;
    }

    public Object[] createRecipeObjectArrayNBT() {
        Object[] objs = new Object[this.shape.size() + this.objects.size() * 2];
        Object[] original = this.createRecipeObjectArray();
        for (int i = 0; i < objs.length; ++i) {
            Object o = original[i];
            if (o instanceof ItemStack) {
                o = new IngredientNBTBC((ItemStack)o);
            }
            objs[i] = o;
        }
        return objs;
    }

    public ShapedOreRecipe buildRotated() {
        int fromRows = this.shape.size();
        int toRows = this.shape.get(0).length();
        StringBuilder[] strings = new StringBuilder[toRows];
        for (int toRow = 0; toRow < toRows; ++toRow) {
            strings[toRow] = new StringBuilder();
        }
        for (String toAdd : this.shape) {
            for (int i = 0; i < toRows; ++i) {
                strings[i].append(toAdd.charAt(i));
            }
        }
        Object[] objs = new Object[toRows + this.objects.size() * 2];
        int offset = 0;
        for (StringBuilder string : strings) {
            objs[offset++] = string.toString();
        }
        for (char c : this.objects.keys()) {
            objs[offset++] = Character.valueOf(c);
            objs[offset++] = this.objects.get(c);
        }
        return new ShapedOreRecipe(this.result.func_77973_b().getRegistryName(), this.result, objs);
    }

    private void ensureValid() {
        if (this.result.func_190926_b()) {
            throw new IllegalStateException("Result hasn't been set yet!");
        }
    }

    public void register() {
        this.ensureValid();
        ResourceLocation name = this.result.func_77973_b().getRegistryName();
        ShapedOreRecipe recipe = new ShapedOreRecipe(name, this.result, this.createRecipeObjectArray());
        ForgeRegistries.RECIPES.register(recipe.setRegistryName(name));
    }

    public void registerNbtAware(String regName) {
        this.ensureValid();
        ShapedOreRecipe recipe = new ShapedOreRecipe(this.result.func_77973_b().getRegistryName(), this.result, this.createRecipeObjectArrayNBT());
        ForgeRegistries.RECIPES.register(recipe.setRegistryName(regName));
    }

    public void registerRotated() {
        this.ensureValid();
        ForgeRegistries.RECIPES.register(this.buildRotated().setRegistryName(this.result.func_77973_b().getRegistryName()));
    }
}

